/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.font;

import icyllis.modernui.ModernUI;
import icyllis.modernui.text.FontCollection;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public class FontPaint {
    public static final int REGULAR = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    private static final int FONT_STYLE_MASK = 3;
    protected FontCollection mFontCollection;
    protected Locale mLocale;
    protected int mFontStyle;
    protected int mFontSize;

    public FontPaint() {
        this.mFontCollection = FontCollection.SANS_SERIF;
        this.mLocale = ModernUI.get().getSelectedLocale();
    }

    public FontPaint(@Nonnull FontPaint paint) {
        this.set(paint);
    }

    public void set(@Nonnull FontPaint paint) {
        this.mFontCollection = paint.mFontCollection;
        this.mLocale = paint.mLocale;
        this.mFontStyle = paint.mFontStyle;
        this.mFontSize = paint.mFontSize;
    }

    public void setFontCollection(@Nonnull FontCollection fontCollection) {
        this.mFontCollection = fontCollection;
    }

    @Nonnull
    public FontCollection getFontCollection() {
        return this.mFontCollection;
    }

    public void setTextLocale(@Nonnull Locale locale) {
        if (!locale.equals(this.mLocale)) {
            this.mLocale = locale;
        }
    }

    @Nonnull
    public Locale getTextLocale() {
        return this.mLocale;
    }

    public void setFontStyle(int fontStyle) {
        this.mFontStyle = (fontStyle & 0xFFFFFFFC) == 0 ? fontStyle : 0;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public int getFontSize() {
        return this.mFontSize;
    }

    public void setFontSize(int fontSize) {
        this.mFontSize = fontSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontPaint that = (FontPaint)o;
        if (this.mFontStyle != that.mFontStyle) {
            return false;
        }
        if (this.mFontSize != that.mFontSize) {
            return false;
        }
        if (!Objects.equals(this.mFontCollection, that.mFontCollection)) {
            return false;
        }
        return Objects.equals(this.mLocale, that.mLocale);
    }

    public int hashCode() {
        int result = this.mFontCollection != null ? this.mFontCollection.hashCode() : 0;
        result = 31 * result + (this.mLocale != null ? this.mLocale.hashCode() : 0);
        result = 31 * result + this.mFontStyle;
        result = 31 * result + this.mFontSize;
        return result;
    }
}

